/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction.repair;

import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccess;
import com.ibm.hwmca.fw.service.extdata.ExternalDataAccessFactory;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.service.serviceaction.repair.PIEndOfCall;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.panel.PBCommonInfoCenterRepairSupport;
import com.ibm.hwmca.xfw.service.panel.PBCommonNoRefcodeRepair;
import com.ibm.hwmca.xfw.service.panel.PBCommonPostInfoCenterRepairSupport;
import com.ibm.hwmca.xfw.service.serviceaction.DefaultServiceAction;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PIInfoCenterRepair
extends DefaultServiceAction {
    private static final String TRACE_MASKT = "XRVPICRT";
    private static final String TRACE_MASKF = "XRVPICRF";
    private static final String TRACE_MASKD = "XRVPICRD";
    protected String infoCenterFileName = "ipha6/kickoff.htm";
    protected String referenceCodeTitleString = "Reference Code";

    public PIInfoCenterRepair() {
        Trace.trace(TRACE_MASKT, "<> PIInfoCenterRepair default ctor");
    }

    public PIInfoCenterRepair(PersistentData persistentData) throws ServiceActionException {
        super(persistentData);
        Trace.trace(TRACE_MASKT, "<> PIInfoCenterRepair persistent data ctor. persistentData: " + persistentData);
    }

    public void start(Map userData) throws ServiceActionException {
        block14: {
            Trace.trace(TRACE_MASKT, "-> PIInfoCenterRepair.start");
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            try {
                String hmcIPAddress;
                HashMap<String, Object> displayMap = new HashMap<String, Object>();
                CommonProblem cp = (CommonProblem)userData.get("SERVICEABLE_EVENT");
                displayMap.put("srctitle", this.referenceCodeTitleString);
                displayMap.put("src", cp.getSRC());
                displayMap.put("problemnumber", String.valueOf(cp.getProblemNumber()));
                if (cp.getSRC() == null || cp.getSRC().trim().length() == 0) {
                    String serviceableEventText;
                    displayMap.put("additionalinfo", "none");
                    if (cp instanceof PIProblem && (serviceableEventText = ((PIProblem)cp).getServiceableEventText().toString()) != null && serviceableEventText.trim().length() > 0) {
                        displayMap.put("additionalinfo", serviceableEventText);
                    }
                    PBCommonNoRefcodeRepair bean = new PBCommonNoRefcodeRepair();
                    bean.setDataMap(displayMap);
                    bean = (PBCommonNoRefcodeRepair)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", bean.getTemplateName(), bean, userData);
                    break block14;
                }
                PBCommonInfoCenterRepairSupport bean = new PBCommonInfoCenterRepairSupport();
                bean.setDataMap(displayMap);
                bean = (PBCommonInfoCenterRepairSupport)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", bean.getTemplateName(), bean, userData);
                if (bean.isSecondRadioButtonSelected()) {
                    Trace.trace(TRACE_MASKF, "PIInfoCenterRepair.start user selected to delay....");
                    break block14;
                }
                Locale clientLocale = Locale.US;
                try {
                    hmcIPAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "PIInfoCenterRepair.start exception caught getting hmc ip addres; using 127.0.0.1");
                    hmcIPAddress = "127.0.0.1";
                }
                ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
                ExternalDataAccess eda = null;
                try {
                    ExternalDataAccessFactory edaf = (ExternalDataAccessFactory)ms.getFactory("ExternalDataAccessFactory");
                    if (edaf == null) {
                        Trace.trace(TRACE_MASKT, "<-! PIInfoCenterRepair.start ExternalDataAccessFactory not set in userData");
                        throw new ServiceActionException("ExternalDataAccessFactory not set in userData");
                    }
                    eda = edaf.create(null);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-! PIInfoCenterRepair.start undable to create ExternalDataAccess, exception=" + e);
                    Trace.trace(TRACE_MASKT, e);
                }
                displayMap.put("EXTERNAL_DATA_ACCESS", eda);
                displayMap.put("HMC_HOSTNAME", hmcIPAddress);
                eda.setToken((Serializable)((Object)this.makeInfoCenterURL(hmcIPAddress, clientLocale)));
                PBCommonPostInfoCenterRepairSupport returnPanelBean = new PBCommonPostInfoCenterRepairSupport();
                returnPanelBean.setDataMap(displayMap);
                returnPanelBean = (PBCommonPostInfoCenterRepairSupport)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", returnPanelBean.getTemplateName(), returnPanelBean, userData);
                if (returnPanelBean.isFirstRadioButtonSelected()) {
                    try {
                        ProblemManager.getProblemManager().close(cp);
                        PIEndOfCall.endOfCallProcessing(userData);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKT, "PIInfoCenterRepair.start exception caught closing associated problem - ignoring [" + e + "]");
                    }
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "<-! PIInfoCenterRepair.start exception caught: " + e);
                Trace.trace(TRACE_MASKF, e);
                if (e instanceof ServiceActionException) {
                    throw (ServiceActionException)e;
                }
                throw new ServiceActionException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- PIInfoCenterRepair.start");
    }

    protected String makeInfoCenterURL(String ipaddr, Locale locale) {
        Trace.trace(TRACE_MASKT, "-> PIInfoCenterRepair.makeURL (locale=" + locale + ")");
        String correctUrl = ":4411/eserver/HW/" + locale.getLanguage() + "_" + locale.getCountry() + "/info/";
        String enUsUrl = ":4411/eserver/HW/en_US/info/";
        if (correctUrl.length() != enUsUrl.length()) {
            Trace.trace(TRACE_MASKF, "PIInfoCenterRepair.makeURL unknown/unsupported locale[" + locale + "], using en_US");
            correctUrl = enUsUrl;
        }
        String retUrl = "http://" + ipaddr + correctUrl + this.infoCenterFileName;
        Trace.trace(TRACE_MASKT, "<- PIInfoCenterRepair.makeURL: " + retUrl);
        return retUrl;
    }
}

